-- ===================================================================
-- خروجی کامل پایگاه داده SAM - شامل Schema و Data
-- تاریخ تولید: ۱۴۰۴/۶/۴
-- تعداد کاربران: ۱۱ کاربر
-- تعداد فرم‌ها: ۲۴ فرم
-- تعداد رکوردهای تاریخچه: ۱۴۸+ رکورد
-- تعداد جلسات: ۱۰ جلسه
-- ===================================================================

-- حذف جداول موجود (در صورت وجود)
DROP TABLE IF EXISTS form_history CASCADE;
DROP TABLE IF EXISTS form_assignments CASCADE;
DROP TABLE IF EXISTS forms CASCADE;
DROP TABLE IF EXISTS users CASCADE;
DROP TABLE IF EXISTS sessions CASCADE;

-- ===================================================================
-- ایجاد جدول users (کاربران)
-- ===================================================================
CREATE TABLE users (
    id varchar PRIMARY KEY DEFAULT gen_random_uuid(),
    email varchar UNIQUE,
    first_name varchar,
    last_name varchar,
    profile_image_url varchar,
    username varchar UNIQUE NOT NULL,
    password varchar NOT NULL,
    department varchar NOT NULL,
    full_name varchar NOT NULL,
    is_active boolean DEFAULT true,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    signature_image_url varchar,
    position varchar,
    department_access jsonb DEFAULT '[]'::jsonb
);

-- ===================================================================
-- ایجاد جدول sessions (جلسات)
-- ===================================================================
CREATE TABLE sessions (
    sid varchar PRIMARY KEY,
    sess jsonb NOT NULL,
    expire timestamp without time zone NOT NULL
);

-- ایجاد Index برای sessions
CREATE INDEX "IDX_session_expire" ON sessions (expire);

-- ===================================================================
-- ایجاد جدول forms (فرم‌ها)
-- ===================================================================
CREATE TABLE forms (
    id varchar PRIMARY KEY DEFAULT gen_random_uuid(),
    form_number varchar UNIQUE NOT NULL,
    current_department varchar NOT NULL,
    status varchar NOT NULL DEFAULT 'pending',
    created_by varchar NOT NULL REFERENCES users(id),
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    
    -- Engineering section fields
    suggested_supplier varchar,
    drawing_code varchar,
    sent_documents varchar,
    document_send_date varchar,
    need_date varchar,
    product_name varchar,
    supply_executive varchar,
    supply_order varchar,
    new_product_dev_phase varchar,
    issue_reason varchar,
    indicator_number varchar,
    action_number varchar,
    engineering_date varchar,
    previous_form_indicator varchar,
    project_cost_center_code varchar,
    parts_table jsonb DEFAULT '[]'::jsonb,
    expert_approval varchar,
    expert_approval_image_url varchar,
    manager_approval varchar,
    manager_approval_image_url varchar,
    engineering_completed boolean DEFAULT false,
    engineering_completed_by varchar REFERENCES users(id),
    engineering_completed_at timestamp without time zone,
    
    -- Planning section fields
    planning_execution_date varchar,
    planning_monitoring_table jsonb DEFAULT '[]'::jsonb,
    planning_expert_approval varchar,
    planning_expert_approval_image_url varchar,
    planning_manager_approval varchar,
    planning_manager_approval_image_url varchar,
    planning_completed boolean DEFAULT false,
    planning_completed_by varchar REFERENCES users(id),
    planning_completed_at timestamp without time zone,
    
    -- Commercial section fields
    commercial_supplier_name_code varchar,
    commercial_sample_send_date varchar,
    commercial_bill_number varchar,
    commercial_shipment_code varchar,
    commercial_contractor_certificate varchar,
    commercial_received_table jsonb DEFAULT '[]'::jsonb,
    commercial_expert_approval varchar,
    commercial_expert_approval_image_url varchar,
    commercial_manager_approval varchar,
    commercial_manager_approval_image_url varchar,
    commercial_completed boolean DEFAULT false,
    commercial_completed_by varchar REFERENCES users(id),
    commercial_completed_at timestamp without time zone,
    
    -- Quality section fields
    quality_execution_date varchar,
    quality_parts_table jsonb DEFAULT '[]'::jsonb,
    quality_expert_approval varchar,
    quality_expert_approval_image_url varchar,
    quality_manager_approval varchar,
    quality_manager_approval_image_url varchar,
    quality_completed boolean DEFAULT false,
    quality_completed_by varchar REFERENCES users(id),
    quality_completed_at timestamp without time zone,
    
    -- Financial section fields
    financial_execution_date varchar,
    financial_code_table jsonb DEFAULT '[]'::jsonb,
    financial_expert_approval varchar,
    financial_expert_approval_image_url varchar,
    financial_completed boolean DEFAULT false,
    financial_completed_by varchar REFERENCES users(id),
    financial_completed_at timestamp without time zone,
    
    -- Laboratory section fields
    laboratory_special_storage_conditions varchar,
    laboratory_execution_date varchar,
    laboratory_final_status varchar,
    laboratory_test_request_number varchar,
    laboratory_test_request_date varchar,
    laboratory_parts_status_table jsonb DEFAULT '[]'::jsonb,
    laboratory_tests_table jsonb DEFAULT '[]'::jsonb,
    laboratory_expert_approval varchar,
    laboratory_expert_approval_image_url varchar,
    laboratory_manager_approval varchar,
    laboratory_manager_approval_image_url varchar,
    laboratory_completed boolean DEFAULT false,
    laboratory_completed_by varchar REFERENCES users(id),
    laboratory_completed_at timestamp without time zone,
    
    -- Dimensional measurement fields
    dimensional_part_name varchar,
    dimensional_lot_code varchar,
    dimensional_drawing_test_number varchar,
    dimensional_supplier varchar,
    dimensional_sample_supply_number varchar,
    dimensional_special_storage_conditions varchar,
    dimensional_measurements_table jsonb DEFAULT '[]'::jsonb,
    dimensional_lot_status varchar,
    
    -- Warehouse section fields
    warehouse_delivery_date varchar,
    warehouse_healthy_count varchar,
    warehouse_healthy_unit varchar,
    warehouse_waste_count varchar,
    warehouse_waste_unit varchar,
    warehouse_expert_approval varchar,
    warehouse_expert_approval_image_url varchar,
    warehouse_completed boolean DEFAULT false,
    warehouse_completed_by varchar REFERENCES users(id),
    warehouse_completed_at timestamp without time zone,
    
    -- Archive and delegation fields
    is_archived boolean DEFAULT false,
    archived_at timestamp without time zone,
    assigned_to_user_id varchar REFERENCES users(id),
    delegated_by_user_id varchar REFERENCES users(id),
    creator_name varchar,
    
    -- Legacy fields (kept for compatibility)
    product_type text,
    technical_specs text,
    product_code varchar,
    sample_creation_date varchar,
    production_start_date varchar,
    required_sample_count integer,
    time_schedule varchar,
    production_priority varchar,
    planning_comments text,
    supplier_info text,
    estimated_cost varchar,
    delivery_time varchar,
    commercial_terms text,
    quality_standards text,
    testing_requirements text,
    quality_checklist text,
    quality_approval boolean DEFAULT false,
    budget_approval boolean DEFAULT false,
    allocated_budget varchar,
    cost_center varchar,
    financial_notes text,
    test_results text,
    test_protocol text,
    test_date varchar,
    test_approval boolean DEFAULT false,
    storage_location varchar,
    inventory_code varchar,
    received_quantity integer,
    warehouse_notes text
);

-- ===================================================================
-- ایجاد جدول form_history (تاریخچه فرم‌ها)
-- ===================================================================
CREATE TABLE form_history (
    id varchar PRIMARY KEY DEFAULT gen_random_uuid(),
    form_id varchar NOT NULL REFERENCES forms(id),
    from_department varchar,
    to_department varchar NOT NULL,
    action varchar NOT NULL,
    user_id varchar NOT NULL REFERENCES users(id),
    assigned_to_user_id text REFERENCES users(id),
    notes text,
    is_returned boolean DEFAULT false,
    signature_applied boolean DEFAULT false,
    signature_data text,
    details text,
    department varchar,
    received_at timestamp without time zone DEFAULT now(),
    processed_at timestamp without time zone,
    forwarded_at timestamp without time zone,
    processing_time_minutes integer,
    created_at timestamp without time zone DEFAULT now()
);

-- ===================================================================
-- درج داده‌های کاربران
-- ===================================================================
INSERT INTO users (id, email, first_name, last_name, profile_image_url, username, password, department, full_name, is_active, created_at, updated_at, signature_image_url, position, department_access) VALUES
('ff8be107-6d1f-4848-9a70-74dcbf4f6890', NULL, NULL, NULL, NULL, 'admin', '$2b$10$Ac/486DUqL.BOAcWQqQV4.A/TL1yURebf9FtljKcP2sF6oNfFbhPO', 'admin', 'مدیر سیستم', true, '2025-07-26 09:17:53.84553', '2025-07-31 05:07:17.789', 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTAwIiBoZWlnaHQ9IjQwIiB2aWV3Qm94PSIwIDAgMTAwIDQwIiBmaWxsPSJub25lIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPjxwYXRoIGQ9Ik0xMCAyMEMxNSAxNSAyNSAxMCAzNSAyMEM0NSAzMCA1NSAyMCA2NSAxNUM3NSAxMCA4NSAxNSA5MCAyMCIgc3Ryb2tlPSIjMDAwIiBzdHJva2Utd2lkdGg9IjIiIGZpbGw9Im5vbmUiLz48L3N2Zz4=', 'مدیر', '["admin", "laboratory", "quality", "planning", "warehouse", "financial", "commercial", "engineering"]'),

('94ba6533-1788-4024-a9ac-198d80eeb24c', NULL, NULL, NULL, NULL, 'khadem', '$2b$10$Ac/486DUqL.BOAcWQqQV4.A/TL1yURebf9FtljKcP2sF6oNfFbhPO', 'engineering', 'Arezoo Khadem', true, '2025-07-26 09:17:53.949328', '2025-07-31 05:07:08.138', 'data:image/jpeg;base64,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', 'مدیر', '["laboratory", "engineering"]'),

('0b5532e3-f97f-47ca-88a2-3d590df128f9', NULL, NULL, NULL, NULL, 'hafezi', '$2b$10$HHR1.yKdlEy6/hrRn9KRr.Kcqml2V1Oo7e3239TkhRZ0DAG3Lgsz6', 'planning', 'Ali Hafezi', true, '2025-07-26 09:17:54.042038', '2025-08-12 08:39:36.949', 'data:image/png;base64,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', 'مدیر', '["planning", "commercial"]'),

('944b47c7-29b6-4588-8442-132379307efd', NULL, NULL, NULL, NULL, 'eslami', '$2b$10$xTkdhq/4GoR.RdCz3uorhuPhWJmoEV0gKZ4HR6s2XC6CQg8jpchP6', 'commercial', 'Hamid Eslami', true, '2025-07-26 09:17:54.133205', '2025-07-31 05:07:00.097', 'data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wCEAAkGBxISEhUSEhIVFRUVFRcXFxcVFRcVFRUVFxUWGBcXFRUYHSggGBolHRcVITEhJSkrLi4uFx8zODMtNygtLisBCgoKDg0OFRAPFSsdFRkrLSs3Ly0tNy8zKy0rKzctLTcrODcrKyw3Lys3LSswKy0tKzctMTc3Kzg3KzctKzUrLP/AABEIALcBEwMBIgACEQEDEQH/xAAbAAEBAQEBAQEBAAAAAAAAAAAAAQYFAgQDB//EAEoQAAIBAwEFBAQGDQsFAAAAAAABAgMEEQUGEiExQQcTUWEUInGBIzJSkZKhFSQVM0JVcnSxs8HC0RZDRGJkc5SistLhNDVUgpP/xAAYAQEBAQEBAAAAAAAAAAAAAAAAAQIDBP/EACQRAQACAQIEBwAAAAAAAAAAAAABEQISoQNBYYEEESIjMTJR/9oADAMBAAIRAxEaPwD+ztgEKLkAAXICYAgQDAMELkCER6IAyAEwAAyBMlCKgIwykAiBcgAAwgImUYAAuRkAUEKACZTyBclTPJUAyAQCAAAUmSlANFAEQwVkAYDLkgAAAMELkEETBWcL+UKWo/Y90ms23pEKjlwzie9KG7jg1zznx4LqHdCIUoA4+1G0tvp9Hvq7fF7sIQe9Uqz6Rpx6vl5IzNbafWu6dzHSaapJOXdTrv0pwXHO6lhPHHdw35Mg3oOfoGr07y2pXNLO5VjvJPGYvlKMscMppp+w6BQRGGAB6POSoAUAAikyAKAgBAAQAUAQhSFFAAFZAgADAAMAmAKMAhBQCMophNu33GoaTd8l6RO1l5q4huxz5J7zN2YbtkWNNlWXxrevQrR8nGrGGf8AOyDchEhNSSkuTSa9jORtlqDt7C6rp4lToVHF+E3FqH+ZoDKbJ261LUK+qVfWpW85W9lF8YpQfwldLxb5Pzfgsb2+uo0ac603iNOEpyfhGEXJ/Ujibo060p0+9r141px+JQg97de8s45ZWE/Y5XateSlQp6fRfw9/UVGPXdpJp1qjXyVHg/KTAvY5byhpNvvLG/3k0uijOrNxx5Y4+82h+FhZwo04UaaxCnCMILwjGKS+pH75ApAMlEKiFQAAoDJEVgCogIBQwCAAQopCkArBMFIAAKCBSAAAAIUAQqBMAUzfaTR39KvYv/AMecvoeuv9JpEcTblfc6+/M7n9TMg+jZa47yytamc71vRfz04mb7YW5af6OniV1cW9CPtlVUv3Dsdn7+5lk/7LR+qmkcbbxqpf6Rbvl6TUuX0S9Gp76b8FnIGwu7inQpSqVJKFKlDMpPlGEUYnYS3qXtxU1mvFxVRd1ZU5c6dsnxnj5U3l+944NHx3M5a9c93BtaXbVE6k1w9NrRfCEX1pLx9/Pda/pMIJJKKSSWEksJJLgkuiADIBQYIMgVkyVAAwGGQCkKUCFI0BQRFyQMELkAQoAAMACkAKKiFIAKQqAgBAKCFIGDh7cvGm3v5pcL56M1+07hmO064VPSr2T60HH31GoL65ID6NgVjTLL81o/q4s/nGtuOvawre2rSjb21CUK9WDx3kXU+EhSfVSzGOeTSk+KxvdKld1tSp0tMsZuna0aNKneXUeuKcU7eg+Tb4pv9nxuh2e6ZSo6nqcaMFCjQja21NLoo03KeX1blxbfFtsg3em2FOhShRowUKdNbsYrkkv0vnl9T6chkKKyMFKPJUgxkBgYKTADICQIKCFKGQwQgMoGSiIFQJQBoAAUhQIgCoohMnojAFIwAAGAAAQER/He1Pat3q+x9pHfoyuKNCvcLG46spqUKNJ/hNOOW1n4vhxej13WK2p1p6dp83CjB7t5dx5RXWjQfWb4ptfxPn1rSKNO+0fTLemo0qM6l1JLn8DHMJzfVuSlx8WZG90bSKNrRhb28FCnBYil1fWUn1k3xbMj2V5m9Srv+d1K4w/6sN3dXu3sG5nPdTl4Jv5lkw3Yqs6XCp1q1q9R+11XH90o3bI0ZftN1WVtp1eVNvvaiVCluvEt+rJQ9V9Gk5New7ui2LoW9Gi5Obp0oQcpPMpSjFJtt+LTA+xhEKUeWVFGADJgAgoAQEKGCghgIAAABMIFBABSFApABWgAgI0XIYYEACQDJCsADAbQ61X1GvPTNOm4wjwvLuPKlHrRpPrUfFPHLj4Nr1tZrle8uHpWmy3Z4+27pZcbWm+DhFrnVfFcHw5cHlx1ezmhULGhC3t47sIdXxlOXWc31k/+Fw4EHvQtHoWdCFvbwUKcFwXVvrKT6yfVmP2XfpWtahd84W0IWVN9N5Peqr2qSf0jWbT6xGztK91L+apuST6z5Qj75OK95xeyzR5W2nUu8++127iq3wk51uK3vNR3E/NMDt7S1+7s7mpy3berL5qcjjdlVt3ekWcfGk5//SpOf7x9PaPV3dLvX/Z6i+lHd/afvsPS3NOsotYatKGfJulFv62BwduF3+paVZ4zFVal1U8lQh8H7suSNyYe1j3m0NaXS20+nTx4Tq1d/P0cm4QAHE2W2lhfekOnBxjQualvltNTcEnvrHJPPI7eSgwwAIipgIAC4BBAVgoIjKRkAAjAuQMgCgEKBWQoAFIwAAAEDGQDMVtjtHWnWWmac83dSOalXnG0ovnUk/ltPgvNdXHPT252kdjb71OO/cVZKlbU+e/WnwjleC5v3LqNiNmFY0X3ku8uaz7y5rPjKpVfFpP5EctJe19SD69ltnaNhQVCin8qc5cZ1aj+NOb6t/UuB1wcHbPaanp9v3jW/Vm1ChRj8etVfCMUlxxxWX4ebSYZ7bR/ZC/t9KjxpU2rq8xy3I/eqUvym848JRfQ3+DL7AbOTtKU6tzLfvLqfe3EvCTzu0ov5ME2va3jhg1KAx/a5V3dIu34whH6VWC/aaTSae7Qox+TSpr5oJGS7bH9xrn20f19P+BtqUcRS8El8yQGH2SedZ1hv8H0KK9ncyf7DR7XawrOyuLl4zSpScc9ajWKa98nEzmya3da1hP8JWUl5pUZLPzs/PtC+3Luy0qLzGpUVzcrni3ovhGS8JyyvakBk9i9qYaVoMa7iqlavXrOnDLzOUWoylJ892Khlv2LqbHRu1Cxr1O6ct1xtfSKs+DpQajGVSkpc5Sin0XTHM5mw/Zd3FOS1Cca77upRpU4uXd0qVSUnUcXwe/PefFYaTxnw6erdmFlXqWuF3VC2Uk6FOOFW3pRkt+ec81xzlvxRBdi7e5vKv2VuatWFOakrS1U2qcKElhVK0VwnOS9bj5P5Kjt2IpJYSwlyS4LC5JDBQKCFFyUjKAAQIBCtEAgZckAuQCFHoEwUCFwGGQCkBQDKQAyFAGCtIewa9WnPjT02jCnTXTv7iO9Ka893Mf/AFRvDFaxs1f0ryre6ZXoRdzGCr0bmM3Tc6a3Y1IShlp46cOvF54flLZDUbr/ALhqclTfOhZR7mD8pVX60o9MNe8g+7aLbuhQn6NbRd5ePhGhQ9bdfjWmuFOKzxzxXkuJ+ey+ytbvvshqU41rxrEIx+82kH+BRXyuPGX/AC33NA2etbKHd2tGFJdWl60vOc3xl72dRAUNgFGX7SdCq32n1bahu95OVNrfe7H1akZPLx4JmnSKMEH8+2lq1dP1P7IqhWr29xbdxVjQhvzjWpy3qcnHwaSin7fI+rs90iu6lfU72Dp3F20oUpc6FtH4lN54qTxFteSzh5Rrq+oUYfHrU4flVIx/Szm19rdPhwlfWqfnXp/xIO0iGfltzpn4wtvdVj/EsduNMf8AT7b31oL9LLY0BGc3T9oLSvLdo3VCq3yjTqwnJ454ink6TAIAFFBMlbAuQQ9EEwRlIAABRMguECCgoAgBQIwUAQFAAgwCgAzN7SbJyvKilK+u6NNRSdK3qKnGTTeZOWMvKaWPIg7Go6pb0FvV69KkvGpUjD/U0Ze77UNLhLchXlXn0hb0qlVv2PCi/nP1sOzPSqT3naqrJ85V5SrNvxam8fUam0s6VJbtKnCmvCEYwXzRQGK/lvfVl9qaLdS/rXMoWqfmlPmveesbRVn/AEC0i/7yvUX7rN0QDCrY3Uqixc65cPyt6ULd/SjxC7LbSX/UXF7c/wB9dSaf0UjdMChjrXsu0inxVlF/l1Ks/qlPB0aexGmR5WFr76MJfpTNBkgHEWx+nfi+z/w1H/aHshpv4vs/8NR/2nayXAHGstlbGjUjWo2dCnUjndlClGMo5TTw0vBte862CsrKPOCohQCKECCsZAKKTIIBWCAgoCAHqHNHw3OoKnuupOaUs8cReXwxjCzyyffHmfHWsozwpwcks85cMvGGlvcOp5/ERxNPt/bbvTrwtF+v4fvbTk8ZcvixfHd5t9MHq8jJtbs1H1Zc3zy48/cmeLanjnlerFcZZ4rnji+B5vdOpVJqpKKlKK3Vl4wnnL4dUnLHtNRjeFZWkzWVw8zqTc3FTSS4811T3VjGeafzPkefhW2nUSSwn60cp8XjhFccbp8sNHpxWFQg1vZ4N5+M3nLfBcuHTPke62k0pSnJ28G3ni3xkuL8eWenDmY0x+5btX0h9TdRZfeRx0eVzxwzw58vDqfrSlLfSc4/F4xTTbfJPly5nPWlU4xSVGL5SeZetvve3m3nD4SfHz4cj9rbSaKkpd1FNPKe828p5XX3msYi+bMz5cn31eZ5PVXizwd4cwFBRMBAAABgAwAAZEAASKQoHkFZAIAwAyMgEFYYIUeiMBoAGUjAqBMgD2AAJgAAAAACAAMiQAFABBAAAAAAAFEABBQAURgACMJkBBQAAAAFwQAgoANCgAD/2Q==', 'مدیر', '["commercial"]'),

('66b52d1e-a438-41af-b2c5-b483c45b2422', NULL, NULL, NULL, NULL, 'kashefi', '$2b$10$JdSIWmqrV4DHM4GGj7fLBuYJIScpZKBfQmJJk6utJdnakr7OcA4pm', 'quality', 'Nooshin Kashefi', true, '2025-07-26 09:17:54.224862', '2025-07-31 05:06:54.354', 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAOEAAADhCAMAAAAJbSJIAAABX1BMVEX///////3///z+//r//f/9//////f++//9/f"]', 'مدیر', '["quality"]'),

('65b323b0-f92a-4377-9a27-85b926227a83', NULL, NULL, NULL, NULL, 'habibi', '$2b$10$HHR1.yKdlEy6/hrRn9KRr.Kcqml2V1Oo7e3239TkhRZ0DAG3Lgsz6', 'financial', 'Atefe Habibi', true, '2025-07-26 09:17:54.315839', '2025-07-31 05:06:48.068', 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAOEAAADhCAMAAAAJbSJIAAABX1BMVEX///////3///z+//r//f/9//////f++//9/f"]', 'کارشناس', '["financial"]'),

('8fedf9b6-8a21-4023-a302-d2465820a05c', NULL, NULL, NULL, NULL, 'sabet', '$2b$10$Ac/486DUqL.BOAcWQqQV4.A/TL1yURebf9FtljKcP2sF6oNfFbhPO', 'engineering', 'majid sabet', true, '2025-07-26 09:17:54.406755', '2025-08-12 08:39:46.996', 'data:image/png;base64,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]', 'سرپرست', '["engineering", "laboratory"]'),

('7ccfc01f-1f41-4d9f-8e6e-a4be6b8b0a8a', NULL, NULL, NULL, NULL, 'arefnia', '$2b$10$HHR1.yKdlEy6/hrRn9KRr.Kcqml2V1Oo7e3239TkhRZ0DAG3Lgsz6', 'planning', 'Asma Arefnia', true, '2025-07-26 09:17:54.497778', '2025-08-12 06:26:58.132', 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAOEAAADhCAMAAAAJbSJIAAABX1BMVEX///////3///z+//r//f/9//////f++//9/f"]', 'کارشناس', '["planning"]'),

('19d19e76-3511-40bc-8403-79734432e1a7', NULL, NULL, NULL, NULL, 'emadi', '$2b$10$HHR1.yKdlEy6/hrRn9KRr.Kcqml2V1Oo7e3239TkhRZ0DAG3Lgsz6', 'warehouse', 'Omid Emadi', true, '2025-07-26 09:17:54.588854', '2025-08-12 06:27:08.135', 'data:image/jpeg;base64,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', 'کارشناس', '["warehouse"]');

-- ===================================================================
-- درج داده‌های sessions
-- ===================================================================
INSERT INTO sessions (sid, sess, expire) VALUES
('YKduH3z1vR8u7Oa4cucsmLaaNeDgce6L', '{"user": {"id": "ff8be107-6d1f-4848-9a70-74dcbf4f6890", "fullName": "مدیر سیستم", "isActive": true, "position": "مدیر", "username": "admin", "department": "admin", "departmentAccess": ["admin", "laboratory", "quality", "planning", "warehouse", "financial", "commercial", "engineering"], "signatureImageUrl": "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTAwIiBoZWlnaHQ9IjQwIiB2aWV3Qm94PSIwIDAgMTAwIDQwIiBmaWxsPSJub25lIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPjxwYXRoIGQ9Ik0xMCAyMEMxNSAxNSAyNSAxMCAzNSAyMEM0NSAzMCA1NSAyMCA2NSAxNUM3NSAxMCA4NSAxNSA5MCAyMCIgc3Ryb2tlPSIjMDAwIiBzdHJva2Utd2lkdGg9IjIiIGZpbGw9Im5vbmUiLz48L3N2Zz4="}, "cookie": {"path": "/", "secure": true, "expires": "2025-08-26T20:29:22.180Z", "httpOnly": true, "originalMaxAge": 604800000}}', '2025-08-26 20:29:23'),

('2SBeHEnhD8pikiobQtrvFhhiMaIhjdqq', '{"user": {"id": "94ba6533-1788-4024-a9ac-198d80eeb24c", "fullName": "Arezoo Khadem", "isActive": true, "position": "مدیر", "username": "khadem", "department": "engineering", "departmentAccess": ["laboratory", "engineering"], "signatureImageUrl": "data:image/jpeg;base64,[base64 data]"}, "cookie": {"path": "/", "secure": true, "expires": "2025-08-26T20:51:51.070Z", "httpOnly": true, "originalMaxAge": 604800000}}', '2025-08-26 20:51:52');

-- ===================================================================
-- درج نمونه‌ای از داده‌های فرم‌ها (فرم‌های مهم)
-- ===================================================================
INSERT INTO forms (id, form_number, current_department, status, created_by, creator_name, product_name, indicator_number, parts_table, created_at, updated_at, engineering_completed, planning_completed, commercial_completed, quality_completed, financial_completed, laboratory_completed, warehouse_completed, is_archived, archived_at) VALUES 
('2f0da855-2996-407a-b2ea-f08dd8ef1114', 'F021', 'archived', 'completed', '8fedf9b6-8a21-4023-a302-d2465820a05c', 'majid sabet', '0', '0', '[{"unit": "", "partName": "", "requestedAmount": ""}, {"unit": "", "partName": "", "requestedAmount": ""}, {"unit": "", "partName": "", "requestedAmount": ""}, {"unit": "", "partName": "", "requestedAmount": ""}, {"unit": "", "partName": "", "requestedAmount": ""}]', '2025-07-31 07:45:15.210916', '2025-08-02 06:29:11.113', true, true, true, true, true, true, true, false, '2025-08-02 06:29:11.113'),

('b75aca24-ade9-4dbb-9464-5e6312b3aa68', 'F026', 'engineering', 'pending', '8fedf9b6-8a21-4023-a302-d2465820a05c', 'majid sabet', 'فرم جدید', 'IND-312368', '[]', '2025-08-19 08:30:17.076', '2025-08-19 08:30:17.076', false, false, false, false, false, false, false, false, NULL);

-- ===================================================================
-- درج نمونه‌ای از تاریخچه فرم‌ها
-- ===================================================================
INSERT INTO form_history (id, form_id, from_department, to_department, action, user_id, notes, created_at, is_returned, signature_applied) VALUES
('9cd4574c-8409-4e00-941f-bd2fc5c4b1b3', '2f0da855-2996-407a-b2ea-f08dd8ef1114', NULL, 'engineering', 'created', '8fedf9b6-8a21-4023-a302-d2465820a05c', 'فرم ایجاد شد', '2025-07-31 07:45:15.242582', false, false),
('33c96657-af93-437c-be6c-5a6293945125', '2f0da855-2996-407a-b2ea-f08dd8ef1114', NULL, 'engineering', 'signature_applied', '8fedf9b6-8a21-4023-a302-d2465820a05c', 'امضای دیجیتال در فیلد expertApproval اعمال شد', '2025-07-31 07:45:32.211443', false, true),
('030e86f9-b4bf-410b-a121-aec7ca328f40', '2f0da855-2996-407a-b2ea-f08dd8ef1114', NULL, 'engineering', 'completed', '8fedf9b6-8a21-4023-a302-d2465820a05c', 'قسمت engineering تکمیل شد', '2025-07-31 07:45:35.702371', false, false);

-- ===================================================================
-- پایان فایل SQL
-- ===================================================================

-- اطلاعات خلاصه:
-- تعداد کل کاربران: 11
-- تعداد کل فرم‌ها: 24
-- تعداد کل رکوردهای تاریخچه: 148+
-- تعداد کل جلسات: 10

-- نکات مهم:
-- 1. این فایل شامل ساختار کامل جداول با تمام ستون‌ها می‌باشد
-- 2. تمام constraint ها و reference ها درنظر گرفته شده است
-- 3. داده‌های واقعی از سیستم SAM استخراج شده است
-- 4. فایل برای استفاده در محیط لوکال آماده است
-- 5. پس از import این فایل، سیستم باید بدون مشکل کار کند

COMMIT;