import { Switch, Route } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { TooltipProvider } from "@/components/ui/tooltip";
import { useAuth } from "@/hooks/useAuth";
import Landing from "@/pages/Landing";
import Home from "@/pages/Home";
import FormView from "@/pages/FormView";
import AdminPanel from "@/pages/AdminPanel";
import ArchivedForms from "@/pages/ArchivedForms";
import PendingForms from "@/pages/PendingForms";
import MonitoringDashboard from "@/pages/MonitoringDashboard";
import NotFound from "@/pages/not-found";

function Router() {
  const { isAuthenticated, isLoading } = useAuth();

  return (
    <Switch>
      {isLoading || !isAuthenticated ? (
        <>
          <Route path="/" component={Landing} />
          <Route path="/login" component={Landing} />
        </>
      ) : (
        <>
          <Route path="/" component={Home} />
          <Route path="/form/:id" component={FormView} />
          <Route path="/admin" component={AdminPanel} />
          <Route path="/archived" component={ArchivedForms} />
          <Route path="/pending" component={PendingForms} />
          <Route path="/monitoring" component={MonitoringDashboard} />
        </>
      )}
      <Route component={NotFound} />
    </Switch>
  );
}

function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <TooltipProvider>
        <div dir="rtl" className="min-h-screen bg-background" style={{ fontFamily: "'Yekan', 'Tahoma', sans-serif" }}>
          <Toaster />
          <Router />
        </div>
      </TooltipProvider>
    </QueryClientProvider>
  );
}

export default App;
