import { CheckCircle } from "lucide-react";

interface ProgressIndicatorProps {
  departments: string[];
  departmentNames: Record<string, string>;
  currentDepartment: string;
  completedDepartments: string[];
}

export default function ProgressIndicator({
  departments,
  departmentNames,
  currentDepartment,
  completedDepartments,
}: ProgressIndicatorProps) {
  const currentIndex = departments.indexOf(currentDepartment);
  const progressPercentage = ((currentIndex + 1) / departments.length) * 100;

  return (
    <div className="mb-8">
      <div className="flex justify-between items-center mb-4">
        <span className="text-sm font-medium text-gray-700">پیشرفت فرم</span>
        <span className="text-sm text-gray-500">
          گام {currentIndex + 1} از {departments.length}
        </span>
      </div>
      
      <div className="w-full bg-gray-200 rounded-full h-2 mb-6">
        <div 
          className="bg-primary h-2 rounded-full progress-bar" 
          style={{ width: `${progressPercentage}%` }}
        ></div>
      </div>
      
      {/* Department Steps */}
      <div className="flex justify-between">
        {departments.map((dept, index) => {
          const isCompleted = completedDepartments.includes(dept);
          const isCurrent = dept === currentDepartment;
          const isPast = index < currentIndex;
          
          return (
            <div key={dept} className="flex flex-col items-center text-xs">
              <div 
                className={`w-8 h-8 rounded-full flex items-center justify-center mb-1 ${
                  isCompleted 
                    ? 'bg-success text-white' 
                    : isCurrent 
                    ? 'bg-primary text-white' 
                    : isPast 
                    ? 'bg-gray-400 text-white' 
                    : 'bg-gray-300 text-gray-600'
                }`}
              >
                {isCompleted ? (
                  <CheckCircle className="w-5 h-5" />
                ) : (
                  <span className="font-medium text-sm">{index + 1}</span>
                )}
              </div>
              <span 
                className={`text-center max-w-[80px] ${
                  isCurrent 
                    ? 'text-primary font-medium' 
                    : isCompleted 
                    ? 'text-success' 
                    : 'text-gray-400'
                }`}
              >
                {departmentNames[dept]}
              </span>
            </div>
          );
        })}
      </div>
    </div>
  );
}
