import { useQuery } from "@tanstack/react-query";

interface User {
  id: string;
  username: string;
  fullName: string;
  department: string;
  isActive: boolean;
  signatureImageUrl?: string;
}

export function useAuth() {
  const { data: user, isLoading } = useQuery<User>({
    queryKey: ["/api/auth/user"],
    retry: false,
  });

  return {
    user,
    isLoading,
    isAuthenticated: !!user,
  };
}
