import { defineConfig } from "drizzle-kit";

// Local development configuration for Drizzle
// برای نصب محلی

// برای استفاده در محیط محلی متغیر DATABASE_URL را در فایل .env تنظیم کنید
if (!process.env.DATABASE_URL) {
  console.warn("DATABASE_URL not found in environment variables");
  console.log("Please create a .env file with DATABASE_URL like:");
  console.log('DATABASE_URL="postgresql://username:password@localhost:5432/database_name"');
}

export default defineConfig({
  out: "D:/SamanehTamin (36)/SamanehTamin/server/migrations",
  schema: "D:/SamanehTamin (36)/SamanehTamin/shared/schema.ts",
  dialect: "postgresql",
  dbCredentials: {
    url: process.env.DATABASE_URL || "postgresql://localhost:5432/persian_workflow_db",
  },
  verbose: true,
  strict: true,
});

