CREATE TABLE "form_assignments" (
	"id" varchar PRIMARY KEY DEFAULT gen_random_uuid() NOT NULL,
	"form_id" varchar NOT NULL,
	"current_department" varchar NOT NULL,
	"assigned_to_user_id" varchar NOT NULL,
	"assigned_by" varchar NOT NULL,
	"assigned_at" timestamp DEFAULT now(),
	"is_active" boolean DEFAULT true,
	"notes" text
);
--> statement-breakpoint
CREATE TABLE "form_history" (
	"id" varchar PRIMARY KEY DEFAULT gen_random_uuid() NOT NULL,
	"form_id" varchar NOT NULL,
	"from_department" varchar,
	"to_department" varchar NOT NULL,
	"action" varchar NOT NULL,
	"user_id" varchar NOT NULL,
	"assigned_to_user_id" varchar,
	"notes" text,
	"is_returned" boolean DEFAULT false,
	"signature_applied" boolean DEFAULT false,
	"signature_data" text,
	"received_at" timestamp DEFAULT now(),
	"processed_at" timestamp,
	"forwarded_at" timestamp,
	"processing_time_minutes" integer,
	"created_at" timestamp DEFAULT now()
);
--> statement-breakpoint
CREATE TABLE "forms" (
	"id" varchar PRIMARY KEY DEFAULT gen_random_uuid() NOT NULL,
	"form_number" varchar NOT NULL,
	"current_department" varchar NOT NULL,
	"assigned_to_user_id" varchar,
	"delegated_by_user_id" varchar,
	"status" varchar DEFAULT 'pending' NOT NULL,
	"created_by" varchar NOT NULL,
	"creator_name" varchar,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	"archived_at" timestamp,
	"suggested_supplier" varchar,
	"drawing_code" varchar,
	"sent_documents" varchar,
	"document_send_date" varchar,
	"need_date" varchar,
	"product_name" varchar,
	"supply_executive" varchar,
	"supply_order" varchar,
	"new_product_dev_phase" varchar,
	"issue_reason" varchar,
	"indicator_number" varchar,
	"action_number" varchar,
	"engineering_date" varchar,
	"previous_form_indicator" varchar,
	"project_cost_center_code" varchar,
	"parts_table" jsonb DEFAULT '[]'::jsonb,
	"expert_approval" varchar,
	"expert_approval_image_url" varchar,
	"manager_approval" varchar,
	"manager_approval_image_url" varchar,
	"engineering_completed" boolean DEFAULT false,
	"engineering_completed_by" varchar,
	"engineering_completed_at" timestamp,
	"planning_execution_date" varchar,
	"planning_monitoring_table" jsonb DEFAULT '[]'::jsonb,
	"planning_expert_approval" varchar,
	"planning_expert_approval_image_url" varchar,
	"planning_manager_approval" varchar,
	"planning_manager_approval_image_url" varchar,
	"planning_completed" boolean DEFAULT false,
	"planning_completed_by" varchar,
	"planning_completed_at" timestamp,
	"commercial_supplier_name_code" varchar,
	"commercial_sample_send_date" varchar,
	"commercial_bill_number" varchar,
	"commercial_shipment_code" varchar,
	"commercial_contractor_certificate" varchar,
	"commercial_received_table" jsonb DEFAULT '[]'::jsonb,
	"commercial_expert_approval" varchar,
	"commercial_expert_approval_image_url" varchar,
	"commercial_manager_approval" varchar,
	"commercial_manager_approval_image_url" varchar,
	"commercial_completed" boolean DEFAULT false,
	"commercial_completed_by" varchar,
	"commercial_completed_at" timestamp,
	"quality_execution_date" varchar,
	"quality_parts_table" jsonb DEFAULT '[]'::jsonb,
	"quality_expert_approval" varchar,
	"quality_expert_approval_image_url" varchar,
	"quality_manager_approval" varchar,
	"quality_manager_approval_image_url" varchar,
	"quality_completed" boolean DEFAULT false,
	"quality_completed_by" varchar,
	"quality_completed_at" timestamp,
	"financial_execution_date" varchar,
	"financial_code_table" jsonb DEFAULT '[]'::jsonb,
	"financial_expert_approval" varchar,
	"financial_expert_approval_image_url" varchar,
	"financial_completed" boolean DEFAULT false,
	"financial_completed_by" varchar,
	"financial_completed_at" timestamp,
	"laboratory_special_storage_conditions" varchar,
	"laboratory_execution_date" varchar,
	"laboratory_final_status" varchar,
	"laboratory_test_request_number" varchar,
	"laboratory_test_request_date" varchar,
	"laboratory_parts_status_table" jsonb DEFAULT '[]'::jsonb,
	"laboratory_tests_table" jsonb DEFAULT '[]'::jsonb,
	"laboratory_expert_approval" varchar,
	"laboratory_expert_approval_image_url" varchar,
	"laboratory_manager_approval" varchar,
	"laboratory_manager_approval_image_url" varchar,
	"dimensional_part_name" varchar,
	"dimensional_lot_code" varchar,
	"dimensional_drawing_test_number" varchar,
	"dimensional_supplier" varchar,
	"dimensional_sample_supply_number" varchar,
	"dimensional_special_storage_conditions" varchar,
	"dimensional_measurements_table" jsonb DEFAULT '[]'::jsonb,
	"dimensional_lot_status" varchar,
	"laboratory_completed" boolean DEFAULT false,
	"laboratory_completed_by" varchar,
	"laboratory_completed_at" timestamp,
	"warehouse_delivery_date" varchar,
	"warehouse_healthy_count" varchar,
	"warehouse_healthy_unit" varchar,
	"warehouse_waste_count" varchar,
	"warehouse_waste_unit" varchar,
	"warehouse_expert_approval" varchar,
	"warehouse_expert_approval_image_url" varchar,
	"warehouse_completed" boolean DEFAULT false,
	"warehouse_completed_by" varchar,
	"warehouse_completed_at" timestamp,
	"is_archived" boolean DEFAULT false,
	CONSTRAINT "forms_form_number_unique" UNIQUE("form_number")
);
--> statement-breakpoint
CREATE TABLE "sessions" (
	"sid" varchar PRIMARY KEY NOT NULL,
	"sess" jsonb NOT NULL,
	"expire" timestamp NOT NULL
);
--> statement-breakpoint
CREATE TABLE "users" (
	"id" varchar PRIMARY KEY DEFAULT gen_random_uuid() NOT NULL,
	"email" varchar,
	"first_name" varchar,
	"last_name" varchar,
	"profile_image_url" varchar,
	"signature_image_url" varchar,
	"username" varchar NOT NULL,
	"password" varchar NOT NULL,
	"department" varchar NOT NULL,
	"position" varchar,
	"full_name" varchar NOT NULL,
	"department_access" jsonb DEFAULT '[]'::jsonb,
	"is_active" boolean DEFAULT true,
	"created_at" timestamp DEFAULT now(),
	"updated_at" timestamp DEFAULT now(),
	CONSTRAINT "users_email_unique" UNIQUE("email"),
	CONSTRAINT "users_username_unique" UNIQUE("username")
);
--> statement-breakpoint
ALTER TABLE "form_assignments" ADD CONSTRAINT "form_assignments_form_id_forms_id_fk" FOREIGN KEY ("form_id") REFERENCES "public"."forms"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "form_assignments" ADD CONSTRAINT "form_assignments_assigned_to_user_id_users_id_fk" FOREIGN KEY ("assigned_to_user_id") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "form_assignments" ADD CONSTRAINT "form_assignments_assigned_by_users_id_fk" FOREIGN KEY ("assigned_by") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "form_history" ADD CONSTRAINT "form_history_form_id_forms_id_fk" FOREIGN KEY ("form_id") REFERENCES "public"."forms"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "form_history" ADD CONSTRAINT "form_history_user_id_users_id_fk" FOREIGN KEY ("user_id") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "form_history" ADD CONSTRAINT "form_history_assigned_to_user_id_users_id_fk" FOREIGN KEY ("assigned_to_user_id") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "forms" ADD CONSTRAINT "forms_assigned_to_user_id_users_id_fk" FOREIGN KEY ("assigned_to_user_id") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "forms" ADD CONSTRAINT "forms_delegated_by_user_id_users_id_fk" FOREIGN KEY ("delegated_by_user_id") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "forms" ADD CONSTRAINT "forms_created_by_users_id_fk" FOREIGN KEY ("created_by") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "forms" ADD CONSTRAINT "forms_engineering_completed_by_users_id_fk" FOREIGN KEY ("engineering_completed_by") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "forms" ADD CONSTRAINT "forms_planning_completed_by_users_id_fk" FOREIGN KEY ("planning_completed_by") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "forms" ADD CONSTRAINT "forms_commercial_completed_by_users_id_fk" FOREIGN KEY ("commercial_completed_by") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "forms" ADD CONSTRAINT "forms_quality_completed_by_users_id_fk" FOREIGN KEY ("quality_completed_by") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "forms" ADD CONSTRAINT "forms_financial_completed_by_users_id_fk" FOREIGN KEY ("financial_completed_by") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "forms" ADD CONSTRAINT "forms_laboratory_completed_by_users_id_fk" FOREIGN KEY ("laboratory_completed_by") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
ALTER TABLE "forms" ADD CONSTRAINT "forms_warehouse_completed_by_users_id_fk" FOREIGN KEY ("warehouse_completed_by") REFERENCES "public"."users"("id") ON DELETE no action ON UPDATE no action;--> statement-breakpoint
CREATE INDEX "IDX_session_expire" ON "sessions" USING btree ("expire");